package org.simantics.views.swt.client.impl;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.simantics.views.ViewUtils.LayoutBean;
import org.simantics.views.swt.client.base.SWTViewUtils;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTScrolledComposite extends SingleSWTViewNode<ScrolledComposite> {
	
	private Composite explorers;

	private static final long serialVersionUID = 7932335224632082902L;
	
	public LayoutBean layout;
	
	private int minSize = 100;
	
	protected ScrollListener listener;
	
	public class ScrollListener implements Listener {

		public Control[] composites;

		final public int minSize;
		
		private boolean pending = false;

		public ScrollListener(int minSize) {
			this.minSize = minSize;
		}

		@Override
		public void handleEvent(Event event) {
			handleEvent();
		}

		public void handleEvent() {
			
			if(pending) return;
			
			pending = true;
			
			Display.getCurrent().asyncExec(new Runnable() {

				@Override
				public void run() {
					doHandleEvent();
				}
				
			});
			
		}

		public void doHandleEvent() {

			if(isDisposed()) return;
			
			pending = false;

			Point c = control.getSize();
			Point o = explorers.getSize();
			Point p = explorers.computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
			if(!o.equals(p)) {
				explorers.setSize(c.x-25, p.y);
			}

		}

	}
	
	@Override
	public Control getControl() {
		return explorers;
	}
	
	@Override
	public void createControls(org.eclipse.swt.widgets.Composite parent) {
		
    	control = new ScrolledComposite(parent, SWT.V_SCROLL | SWT.H_SCROLL | SWT.BORDER);
    	
    	setProperties();
		
		listener = new ScrollListener(minSize);

		control.setBackground( (Color) getResourceManager().get( ColorDescriptor.createFrom(new RGB(245, 245, 245)) ) );
		control.setLayout(GridLayoutFactory.fillDefaults()
				.margins(0, 0).spacing(0, 0).create());
		control.setExpandVertical(false);
		control.setExpandHorizontal(false);
		GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(control);

		explorers = new Composite(control, SWT.NONE);
		explorers.setBackground(Display.getCurrent().getSystemColor(
				SWT.COLOR_WHITE));
		// Make sure that exploders are visible
		explorers.setSize(1300, 1300);
		explorers.setLayout(GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1)
				.spacing(0, 0).create());

		control.setMinSize(100, 100);
		control.setContent(explorers);

    	createChildComposites(explorers);
    	
    	listener.composites = explorers.getChildren();
    	
    	control.addListener(SWT.Resize, listener);
    	
    	for (Control composite : listener.composites) {
    		composite.addListener(SWT.Resize, listener);
    	}
    	
	}

	final public void synchronizeLayout(LayoutBean layout) {
		if(layout != null) control.setLayout(SWTViewUtils.toLayout(layout));
	}
	
	public static void propagate(Control control) {
		
		Control parent = control.getParent();
		if(parent == null) return;
		
		if(parent instanceof ScrolledComposite) {
			
			Point c = parent.getSize();
			Point o = control.getSize();
			Point p = control.computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
			if(!o.equals(p)) {
				control.setSize(c.x-25, p.y);
			}
			
		} else {
			
			propagate(parent);
			
		}
		
	}
	
}
