package org.simantics.views.swt.client.impl;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.simantics.views.ViewUtils.LayoutBean;
import org.simantics.views.swt.client.base.SWTViewUtils;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTSashForm extends SingleSWTViewNode<SashForm> {
	
	private static final long serialVersionUID = 7932335224632082902L;
	
	public LayoutBean layout;
	public int[] weights;
	public Integer orientation;
	
	@Override
	public void createControls(org.eclipse.swt.widgets.Composite parent) {
		
    	control = new SashForm(parent, style);
    	
    	createChildComposites();
    	
    	setProperties();
    	
	}

	final public void synchronizeLayout(LayoutBean layout) {
		if(layout != null) control.setLayout(SWTViewUtils.toLayout(layout));
	}

	final public void synchronizeWeights(int[] weights) {
		if(weights != null) {
			int childCount = 0; 
			for(Control c : control.getChildren()) {
				if (c instanceof Sash) continue;
				childCount++;
			}
			if(weights.length != childCount) throw new IllegalStateException("Got " + weights.length + " weights, but had " + childCount + " children.");
			control.setWeights(weights);
		}
	}
	final public void synchronizeOrientation(Integer orientation) {
		if(orientation != null) control.setOrientation(orientation);
	}
	
}
