package org.simantics.views.swt.client.base;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;

public class SWTRoot extends SWTParentNode implements ISWTViewNode {

	private static final long serialVersionUID = -3208359073385767918L;

	private final IWorkbenchSite site;

	private LocalResourceManager resourceManager;

	private Composite body;

	public SWTRoot(IWorkbenchSite site) {
		this.site = site;
	}

	@Override
	public void reset() {
	}
	
	@Override
	public SWTRoot getRootNode() {
		// This is a root node!
		return this;
	}

	public ResourceManager getResourceManager() {
		if (resourceManager == null)
			throw new IllegalStateException("resource manager is null");
		return resourceManager;
	}

	public ResourceManager peekResourceManager() {
		return resourceManager;
	}

	@Override
	public Control getControl() {
		return body;
	}

	@Override
	public IWorkbenchSite getSite() {
		return site;
	}
	
	public void setFocus() {
		body.setFocus();
	}
	
	public void setVisible(boolean value) {
		body.setVisible(value);
	}
	
	public void createControls(Composite parent) {
		body = parent;
		resourceManager = new LocalResourceManager(JFaceResources.getResources(), body);
		for(ISWTViewNode child : getNodes()) child.createControls(body);
	}
	
	public Control getSingleChild() {
		if(children.size() != 1) throw new IllegalStateException("SWTRoot should have exactly one child (has " + children.size() + ").");
		return getNodes().iterator().next().getControl();
	}
	
}
