/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.commandlog;

import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.CommandRecorder;
import org.simantics.utils.commandlog.internal.CommandRecorderTracker;

public class Commands {
    private Commands() {
    }

    public static boolean isRecording() {
        return CommandRecorderTracker.TRACKER != null && CommandRecorderTracker.TRACKER.isRecording();
    }

    public static void record(Command command) {
        CommandRecorderTracker tracker = CommandRecorderTracker.TRACKER;
        if (tracker != null) {
            for (CommandRecorder handler : tracker.commandHandlers) {
                if (!handler.isRecording()) continue;
                handler.handleCommand(command);
            }
        }
    }

    public static void record(Object graph, Command command) {
        CommandRecorderTracker tracker = CommandRecorderTracker.TRACKER;
        if (tracker != null) {
            for (CommandRecorder handler : tracker.commandHandlers) {
                handler.handleCommand(graph, command);
            }
        }
    }
}

