/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.workbench;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.ui.IMemento;
import org.simantics.utils.bytes.Base64;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.EString;

public class StringMemento
implements IMemento {
    public static final String TAG_TEXTDATA = "org.simantics.utils.ui.workbench.StringMemento.TAG_TEXTDATA";
    public static final String CHILD_TAG_CHAR = "#";
    public static final String ESCAPE_SET = ",=#";
    public static final char ESCAPE_CHAR = '\\';
    protected Map<String, String> values = new TreeMap<String, String>();
    protected List<ChildType> types = new ArrayList<ChildType>();
    protected String type = "";

    public StringMemento() {
    }

    public StringMemento(String data) throws IllegalArgumentException {
        this.setStringData(data);
    }

    public IMemento createChild(String type) {
        ChildType ct = new ChildType(new StringMemento());
        ct.memento.type = type;
        this.types.add(ct);
        return ct.memento;
    }

    public IMemento createChild(String type, String id) {
        IMemento result = this.createChild(type);
        result.putString("IMemento.internal.id", id);
        return result;
    }

    public IMemento getChild(String type) {
        for (ChildType ct : this.types) {
            if (!ct.memento.type.equals(type)) continue;
            return ct.memento;
        }
        return null;
    }

    public IMemento[] getChildren() {
        ArrayList<StringMemento> result = new ArrayList<StringMemento>();
        for (ChildType ct : this.types) {
            result.add(ct.memento);
        }
        return result.toArray(new IMemento[result.size()]);
    }

    public IMemento[] getChildren(String type) {
        ArrayList<StringMemento> result = new ArrayList<StringMemento>();
        for (ChildType ct : this.types) {
            if (!ct.memento.type.equals(type)) continue;
            result.add(ct.memento);
        }
        return result.toArray(new IMemento[result.size()]);
    }

    public Boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public Float getFloat(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return new Float(value);
    }

    public Long getLong(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return new Long(value);
    }

    public String getType() {
        return this.type;
    }

    public String getID() {
        return this.getString("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return new Integer(value);
    }

    public String getString(String key) {
        return this.values.get(key);
    }

    public String getTextData() {
        return this.getString(TAG_TEXTDATA);
    }

    public String[] getAttributeKeys() {
        Set<String> keys = this.values.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void putFloat(String key, float value) {
        this.putString(key, new Float(value).toString());
    }

    public void putInteger(String key, int value) {
        this.putString(key, new Integer(value).toString());
    }

    public void putLong(String key, long value) {
        this.putString(key, new Long(value).toString());
    }

    public void putBoolean(String key, boolean value) {
        this.putString(key, String.valueOf(value));
    }

    public StringMemento clone() {
        return new StringMemento(this.toString());
    }

    public void putMemento(IMemento memento) {
        StringMemento sm = (StringMemento)memento;
        this.addStringData(sm.toString());
    }

    public void writeToMemento(IMemento dst) {
        for (Map.Entry<String, String> e : this.values.entrySet()) {
            dst.putString(e.getKey(), e.getValue());
        }
        for (ChildType c : this.types) {
            IMemento cdst = dst.createChild(c.memento.type);
            c.memento.writeToMemento(cdst);
        }
    }

    public void putString(String key, String value) {
        this.values.put(key, value);
    }

    public void putTextData(String data) {
        this.putString(TAG_TEXTDATA, data);
    }

    public boolean isEmpty() {
        return this.values.isEmpty() && this.types.isEmpty();
    }

    protected String escapeString(String str) {
        return EString.escapeString((String)str, (String)ESCAPE_SET, (char)'\\');
    }

    protected String unescapeString(String str) {
        return EString.unescapeString((String)str, (char)'\\');
    }

    private String scanEscapedString(String str, char endMark) {
        return EString.scanEscapedString((String)str, (char)'\\', (char)endMark);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        for (Map.Entry<String, String> e : this.values.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (e.getValue() == null) continue;
            sb.append(this.escapeString(e.getKey()) + "=" + this.escapeString(e.getValue()));
        }
        for (ChildType ct : this.types) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(CHILD_TAG_CHAR + this.escapeString(ct.memento.type) + "=" + this.escapeString(ct.memento.toString()));
        }
        return sb.toString();
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.values.keySet());
    }

    public void setStringData(String data) throws IllegalArgumentException {
        this.clear();
        this.addStringData(data);
    }

    public void clear() {
        this.values.clear();
        this.types.clear();
    }

    public void addStringData(String data) throws IllegalArgumentException {
        for (Pair<String, String> pair : this.scanKeyValues(data)) {
            String key = this.unescapeString((String)pair.first);
            String value = this.unescapeString((String)pair.second);
            if (key.startsWith(CHILD_TAG_CHAR)) {
                String type = key.substring(1);
                StringMemento sm = new StringMemento(value);
                sm.type = type;
                ChildType ct = new ChildType(sm);
                this.types.add(ct);
                continue;
            }
            this.values.put(key, value);
        }
    }

    private List<Pair<String, String>> scanKeyValues(String str) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        while (str.length() > 0) {
            String chunk = this.scanEscapedString(str, ',');
            str = chunk.length() + 1 < str.length() ? str.substring(chunk.length() + 1) : "";
            String key = this.scanEscapedString(chunk, '=');
            chunk = key.length() + 1 < chunk.length() ? chunk.substring(key.length() + 1) : "";
            String value = chunk;
            result.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        }
        return result;
    }

    public static void main(String[] args) {
        StringMemento sm = new StringMemento();
        sm.putString("Level", "1");
        StringMemento sm2 = (StringMemento)sm.createChild("Children");
        sm2.putString("Level", "2");
        StringMemento sm3 = (StringMemento)sm2.createChild("Children");
        sm3.putString("Level", "3");
        new StringMemento(sm.toString());
        System.out.println(sm.getChild("Children").getChild("Children").getString("Level"));
        sm.getChildren("Children");
        System.out.println(sm.toString());
        StringMemento sm5 = new StringMemento();
        IMemento sm6 = sm5.createChild("argument");
        sm6.putString("arg", "-server");
        sm6.putString("value", "localhost:6668");
        System.out.println("simantics link: " + sm5.toString());
        try {
            String b64 = Base64.encode((byte[])sm5.toString().getBytes("UTF-8"));
            System.out.println("simantics link: " + b64);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    class ChildType {
        StringMemento memento;

        public ChildType(StringMemento memento) {
            this.memento = memento;
        }
    }
}

