/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.workbench;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class FocusContextActivator {

    private String             contextId;

    private IContextActivation activation;

    public FocusContextActivator(String contextId, final Control c, final IWorkbenchWindow window) {
        this.contextId = contextId;

        c.addFocusListener(new FocusListener() {
            private IContextService getService() {
                return (IContextService) window.getService(IContextService.class);
            }

            @Override
            public void focusGained(FocusEvent e) {
                IContextService contextService = getService();
                String ctx = FocusContextActivator.this.contextId;
                if (contextService != null && ctx != null)
                    activation = contextService.activateContext(ctx);
            }

            @Override
            public void focusLost(FocusEvent e) {
                IContextService contextService = getService();
                if (contextService != null && activation != null)
                    contextService.deactivateContext(activation);
            }
        });
    }

}
