/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.widgets;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/**
 * A generic SWT event listener that simply consumes and vetoes the incoming
 * event by setting {@link Event#doit} to <code>false</code>.
 * 
 * @author Tuukka Lehtonen
 */
public class VetoingEventHandler implements Listener {

    public static final VetoingEventHandler INSTANCE = new VetoingEventHandler();

    @Override
    public void handleEvent(Event event) {
        event.doit = false;
    }

}