/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 27.12.2006
 */
package org.simantics.utils.ui.gfx;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

/**
 * RGBAdjustmentImageDescriptor
 * @author Toni Kalajainen
 */
@SuppressWarnings("deprecation")
public class RGBAdjustmentImageDescriptor extends ImageDescriptor {
    
    public static final PaletteData DEFAULT_PALETTEDATA = 
        new PaletteData(0x00ff0000, 0x0000ff00, 0x000000ff);
    
    ImageDescriptor desc;
    int r,g,b;

    public RGBAdjustmentImageDescriptor(ImageDescriptor image, int r, int g, int b)
    {
        desc = image;
        this.r = r;
        this.g = g;
        this.b = b;        
    }

    @Override
    public ImageData getImageData() {
        PaletteData palette = DEFAULT_PALETTEDATA;        
        ImageData orig = ImageCache.getInstance().getImage(desc).getImageData();
        ImageData id = new ImageData(orig.width, orig.height, 24, palette);
        id.setAlpha(0,0,0);
        PaletteData origPalette = orig.palette;        
        
        ImageData mask = null;
        if (orig.getTransparencyType()==SWT.TRANSPARENCY_MASK ||
            orig.getTransparencyType()==SWT.TRANSPARENCY_PIXEL)        
            mask = orig.getTransparencyMask();
        
        for (int x=0; x<orig.width; x++)
            for (int y=0; y<orig.height; y++) {
                RGB rgb = origPalette.getRGB( orig.getPixel(x, y) );
                
                int nr = Math.min(255, (rgb.red*r)>>8);
                int ng = Math.min(255, (rgb.green*g)>>8);
                int nb = Math.min(255, (rgb.blue*b)>>8);
                
                rgb = new RGB( nr, ng, nb );
                id.setPixel(x, y, palette.getPixel(rgb));
                int alpha;
                if (mask==null) 
                    alpha = orig.getAlpha(x, y);
                else
                    alpha = (mask.getPixel(x, y)==1?255:0);
                id.setAlpha(x, y, alpha);
            }        
        return id;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj==this) return true;
        if (!(obj instanceof RGBAdjustmentImageDescriptor))
            return false;
        RGBAdjustmentImageDescriptor other = (RGBAdjustmentImageDescriptor) obj;
        return other.desc.equals(desc) && other.r==r && other.g==g && other.b==b;        
    }
    
    @Override
    public int hashCode() {
        return desc.hashCode() ^ r^g^b;
    }
    
}
