/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.threads;

/**
 * Executable is a runnable bound to be ran in a specific thread.
 *
 */
public class Executable 
{
	public final static Executable [] EMPTY_ARRAY = new Executable[0];
		
	public final IThreadWorkQueue threadAccess;
	public final Runnable runnable;
	
	public Executable(IThreadWorkQueue threadAccess, Runnable runnable) {
		this.threadAccess = threadAccess;
		this.runnable = runnable;
	}		

}
