/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;

public abstract class ImmutableCollection<T> implements Collection<T> {

	public boolean add(T e) {
		throw new UnsupportedOperationException();
	}

	public boolean addAll(Collection<? extends T> c) {
		throw new UnsupportedOperationException();
	}

	public void clear() {
		throw new UnsupportedOperationException();
	}

	public boolean remove(Object o) {
		throw new UnsupportedOperationException();
	}

	public boolean removeAll(Collection<?> c) {
		throw new UnsupportedOperationException();
	}

	public boolean retainAll(Collection<?> c) {
		throw new UnsupportedOperationException();
	}

	abstract public boolean contains(Object o);
	abstract public boolean containsAll(Collection<?> c);
	abstract public boolean isEmpty();
	abstract public Iterator<T> iterator();		
	abstract public int size();
	
	public Object[] toArray() {
		Object[] ret = new Object[size()];
		int i=0;
		for(T a : this) 
			ret[i++] = a;
		return ret;
	}

	public <U> U[] toArray(U[] a) {
		// TODO
		throw new UnsupportedOperationException();
	}
	
}
