/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class EmptyIterator<T> implements Iterator<T> {

	@Override
	public boolean hasNext() {		
		return false;
	}

	@Override
	public T next() {
		throw new NoSuchElementException();		
	}

	@Override
	public void remove() {
		throw new IllegalStateException();		
	}

	@SuppressWarnings({ "rawtypes" })
    static public final EmptyIterator instance = new EmptyIterator();	

}
