/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.impl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;

public class TooltipNode extends TrendGraphicalNode {

    private static final long serialVersionUID = 8818424722082593562L;

    public static final AlphaComposite composite = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, .61f);
	
	public boolean visible = true;
	public double time;
	
	@Override
	protected void doRender(Graphics2D g) {
		if ( !visible ) return;
		
		//double w = getWidth();
		//double h = getHeight();
		
		Composite c = g.getComposite();
		g.setComposite(composite);
		try {
			g.setColor(Color.BLACK);
			g.fill( bounds );
		} finally {
			g.setComposite(c);
		}
	}
	
	

}
