/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.junit.v2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.tests.modelled.junit.v2.ModelledSTSTestRunner;
import org.simantics.tests.modelled.utils.ModelledSTSSuite;
import org.simantics.tests.modelled.utils.ModelledSTSTest;

public class ModelledSTSSuiteRunner
extends ParentRunner<ModelledSTSTestRunner> {
    private final ModelledSTSSuite suite;
    private final List<ModelledSTSTestRunner> children;
    private Map<String, List<ModelledSTSTest.CommandSessionVariable>> storedVariables = new HashMap<String, List<ModelledSTSTest.CommandSessionVariable>>();

    public ModelledSTSSuiteRunner(ModelledSTSSuite suite) throws InitializationError {
        super(ModelledSTSSuiteRunner.class);
        this.suite = suite;
        this.children = new ArrayList<ModelledSTSTestRunner>(suite.getChildren().size());
        String exclusionFilter = System.getProperty("org.simantics.tests.modelled.excludeFilter");
        String inclusionFilter = System.getProperty("org.simantics.tests.modelled.singleTestIncludeFilter");
        for (ModelledSTSTest test : suite.getSortedChildren()) {
            String[] filters;
            boolean add = true;
            if (exclusionFilter != null && ModelledSTSSuiteRunner.startsWithAny(test, filters = exclusionFilter.split(","))) {
                add = false;
            }
            if (inclusionFilter != null && !ModelledSTSSuiteRunner.startsWithAny(test, filters = inclusionFilter.split(","))) {
                add = false;
            }
            if (!add) continue;
            this.children.add(new ModelledSTSTestRunner(test));
        }
    }

    private static boolean startsWithAny(ModelledSTSTest test, String[] filters) {
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (test.getName().contains(filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getName() {
        return this.suite.getName();
    }

    protected List<ModelledSTSTestRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(ModelledSTSTestRunner child) {
        return child.getDescription();
    }

    protected void runChild(ModelledSTSTestRunner child, RunNotifier notifier) {
        Description description = this.describeChild(child);
        if (this.isIgnored(child)) {
            notifier.fireTestIgnored(description);
        } else {
            try {
                ArrayList<ModelledSTSTest.CommandSessionVariable> variables = new ArrayList<ModelledSTSTest.CommandSessionVariable>();
                for (String dep : child.getTest().getDependencies()) {
                    List<ModelledSTSTest.CommandSessionVariable> storedVars = this.storedVariables.get(dep);
                    if (storedVars == null) continue;
                    variables.addAll(storedVars);
                }
                notifier.fireTestStarted(description);
                child.runWithVars(variables);
                notifier.fireTestFinished(description);
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(description, e));
            }
        }
    }

    protected boolean isIgnored(ModelledSTSTestRunner child) {
        return child.isIgnored();
    }

    public CombinedCoverage getCoverage() {
        return this.suite.getCoverage();
    }
}

