/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.tests.modelled.ui.STSTestEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STSEditorAdapter
extends AbstractResourceEditorAdapter
implements EditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(STSEditorAdapter.class);

    public STSEditorAdapter() {
        super("STS Test Editor", null, 20);
    }

    public boolean canHandle(ReadGraph g, Object input) throws DatabaseException {
        if (input instanceof IStructuredSelection) {
            input = ((IStructuredSelection)input).getFirstElement();
        }
        if (!(input instanceof Resource)) {
            if (input instanceof IAdaptable) {
                if ((input = ((IAdaptable)input).getAdapter(Resource.class)) == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        Resource resource = (Resource)input;
        return g.isInstanceOf(resource, TestsResource.getInstance((ReadGraph)g).STSTest);
    }

    protected void openEditor(final Resource input) throws Exception {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return;
        }
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                final String uri = graph.getURI(input);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WorkbenchUtils.openEditor((String)"org.simantics.tests.ui.stsTestEditor", (IEditorInput)new STSTestEditorInput(uri));
                        }
                        catch (PartInitException e) {
                            LOGGER.error("Could not initialize part", (Throwable)e);
                        }
                    }
                });
            }
        });
    }
}

