/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;
import org.simantics.scl.compiler.module.coverage.Coverage;

class CoverageViewSorter
extends ViewerComparator {
    private final TreeViewer viewer;
    private Map<TreeColumn, Integer> columns = new HashMap<TreeColumn, Integer>();
    private int currentDirection;

    public CoverageViewSorter(TreeViewer viewer) {
        this.viewer = viewer;
    }

    void addColumn(TreeViewerColumn viewerColumn, int columnidx) {
        final TreeColumn column = viewerColumn.getColumn();
        this.setSortColumnAndDirection(column, 128);
        column.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn current = column.getParent().getSortColumn();
                if (current.equals(column)) {
                    int sortDirection = column.getParent().getSortDirection();
                    CoverageViewSorter.this.setSortColumnAndDirection(column, sortDirection != 1024 ? 1024 : 128);
                } else {
                    CoverageViewSorter.this.setSortColumnAndDirection(column, 1024);
                }
                CoverageViewSorter.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.columns.put(column, columnidx);
    }

    private void setSortColumnAndDirection(TreeColumn sortColumn, int direction) {
        this.currentDirection = direction;
        sortColumn.getParent().setSortColumn(sortColumn);
        sortColumn.getParent().setSortDirection(direction);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        TreeViewer v = (TreeViewer)viewer;
        TreeColumn currentColumn = v.getTree().getSortColumn();
        int res = 0;
        if (e1 instanceof Coverage && e2 instanceof Coverage) {
            Coverage c1 = (Coverage)e1;
            Coverage c2 = (Coverage)e2;
            int indx = this.columns.get(currentColumn);
            switch (indx) {
                case 0: {
                    res = c1.getIdentifier().compareToIgnoreCase(c2.getIdentifier());
                    break;
                }
                case 1: {
                    res = Double.compare(c1.getCoverage(), c2.getCoverage());
                    break;
                }
                case 2: {
                    res = c1.getCoveredCodeSize() - c2.getCoveredCodeSize();
                    break;
                }
                case 3: {
                    res = c1.getMissedCodeSize() - c2.getMissedCodeSize();
                    break;
                }
                case 4: {
                    res = c1.getTotalCodeSize() - c2.getTotalCodeSize();
                }
            }
            res = res == 0 ? c1.getIdentifier().compareTo(c2.getIdentifier()) : (this.isReverseSort() ? -res : res);
        }
        return res;
    }

    private boolean isReverseSort() {
        return this.currentDirection == 1024;
    }
}

