package org.simantics.structural2.variables;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class BrowseConnectionDescriptor extends AbstractVariableConnectionPointDescriptor {
	
	public Variable base;
	public String rel;
	
	public BrowseConnectionDescriptor(Variable base, String rel) {
		this.base = base;
		this.rel = rel;
	}
	@Override
	public int hashCode() {
		return base.hashCode() + 31*rel.hashCode();
	}
	@Override
	public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof BrowseConnectionDescriptor))
            return false;
        BrowseConnectionDescriptor r = (BrowseConnectionDescriptor)object;
        if(!r.rel.equals(rel)) return false;
        if(!r.base.equals(base)) return false;
        return true;
	}
	static class ComputeVariable extends UnaryRead<BrowseConnectionDescriptor, Variable> {

		public ComputeVariable(BrowseConnectionDescriptor desc) {
			super(desc);
		}

		@Override
		public Variable perform(ReadGraph graph) throws DatabaseException {
			return parameter.base.browse(graph, parameter.rel);
		}
		
	}
	@Override
	public Variable getVariable(ReadGraph graph) throws DatabaseException {
		return graph.syncRequest(new ComputeVariable(this), TransientCacheAsyncListener.<Variable>instance());
	}
	public String getURI(ReadGraph graph) throws DatabaseException {
		return getVariable(graph).getURI(graph);
	}
	@Override
	public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
		return getVariable(graph).getPossiblePredicateResource(graph);
	}
	
	@Override
	public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {
		
		Variable baseParent = base.getParent(graph);
		Variable parent = possiblyStructuralCp.getParent(graph);
		Variable parentParent = parent.getParent(graph);
		
		if(baseParent.equals(parentParent)) {
			if(!parent.equals(base)) return false;
		}

		String descURI = getURI(graph);
		String parentURI = parent.getURI(graph);
		if(descURI.startsWith(parentURI)) {
			// Children are in substructure
			if('/' == descURI.charAt(parentURI.length())) return true;
			// Otherwise require exact match
			return descURI.endsWith(possiblyStructuralCp.getName(graph));
		} else {
			return false;
		}
		
	}
	
}