package org.simantics.structural2.scl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;

/**
 * Given component finds a component type it belongs to
 */
public class FindComponentTypeRequest extends ResourceRead<Pair<Resource,Integer>> {

	public FindComponentTypeRequest(Resource resource) {
		super(resource);
	}

	@Override
	public Pair<Resource,Integer> perform(ReadGraph graph) throws DatabaseException {		
		StructuralResource2 STR = StructuralResource2.getInstance(graph);		
		Resource type = graph.getPossibleObject(resource, STR.Defines);
		if(type != null)
			return Pair.make(type, 0);		

		Layer0 L0 = Layer0.getInstance(graph);
		Resource parent = graph.getPossibleObject(resource, L0.PartOf);
		if(parent != null) {
		    Pair<Resource,Integer> result = 
		            graph.syncRequest(new FindComponentTypeRequest(parent));
			return Pair.make(result.first, result.second+1);
		}

		throw new DatabaseException("Unexpected graph structure at " + resource + ".");
	}

}
