package org.simantics.structural2.queries;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;

public class ConnectionJoinComponents extends ResourceRead<Collection<Resource>> {

	public ConnectionJoinComponents(Resource connectionJoin) {
		super(connectionJoin);
	}
	
	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
    	ConnectionSet cs = new ConnectionSet(graph);
    	cs.addJoin(graph, resource);
    	return cs.getConnections();
	}
	
}