/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T> input library node type
 */
public abstract class LibraryViewpointContributor<T extends AbstractNode> extends ViewpointContributor<T> {

    protected abstract Read<Collection<Resource>> getChildRequest(ReadGraph graph, T lib) throws DatabaseException;

    @Override
    public final Collection<?> getContribution(ReadGraph graph, T lib) throws DatabaseException {
        ArrayList<AbstractNode> result = new ArrayList<AbstractNode>();
        Read<Collection<Resource>> read = getChildRequest(graph, lib);
        if (read != null) {
            for (Resource r : graph.syncRequest(read)) {
                try {
                    AbstractNode n = graph.adapt(r, AbstractNode.class);
                    result.add(n);
                } catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    public String getViewpointId() {
        return "Standard";
    }

}
