/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.platform.GraphExplorerView;
import org.simantics.browsing.ui.swt.ViewArgumentUtils;
import org.simantics.db.UndoContext;
import org.simantics.db.common.UndoContextEx;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.ui.Activator;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ModelBrowser extends GraphExplorerView {

    private static final String      CONTEXT_MENU_ID = "#GraphExplorerPopup";
    private static final Set<String> uiContexts      = Collections.singleton("org.simantics.modeling.ui.modelBrowser");
    private static final Set<String> defaultBrowseContexts  = Collections.singleton("http://www.simantics.org/Structural-0.0/ModelBrowser");
    protected UndoContext undoContext = new UndoContextEx("ModelBrowser");

    @Override
    protected Set<String> getUiContexts() {
        return uiContexts;
    }

    @Override
    protected Set<String> getBrowseContexts() {
        return defaultBrowseContexts;
    }

    @Override
    protected String getContextMenuId() {
        return CONTEXT_MENU_ID;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == UndoContext.class)
            return undoContext;
        return super.getAdapter(adapter);
    }

    @Override
    protected void createControls(Composite parent) {
        // Make sure the resource manager of this plug-in is initialized
        // properly before using it in this browser.
        Activator.initializeResourceManager(parent.getDisplay());

        super.createControls(parent);
        //IToolBarManager toolBar = getViewSite().getActionBars().getToolBarManager();
        //toolBar.add(new HomeAction());
    }

    class HomeAction extends Action {
        public HomeAction() {
            super("Home", Action.AS_PUSH_BUTTON);
            setToolTipText("Navigate to root library");
            setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_ETOOL_HOME_NAV));
            setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_ETOOL_HOME_NAV_DISABLED));
        }
        @Override
        public void run() {
            Map<String, String> args = new HashMap<String, String>();
            args.put("view", getSite().getId());
            String argString = ViewArgumentUtils.encodeArguments(args);
            try {
                WorkbenchUtils.showView("org.simantics.browsing.ui.graph.browseDebugger:" + argString);
            } catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected static Set<String> loadBrowseContexts(final Set<String> browseContexts) {
        try {
            return BrowseContext.getBrowseContextClosure(Simantics.getSession(), browseContexts);
        } catch (DatabaseException e) {
            ExceptionUtils.logAndShowError("Failed to load modeled browse contexts for property page, see exception for details.", e);
            return browseContexts;
        }
    }

}
