package org.simantics.spreadsheet.ui.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.VariableStringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.VariableStringPropertyTextModifier;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.PropertyTabContributorImpl;

public class ExpressionCellTab extends PropertyTabContributorImpl {

    public void createControls(Composite body, IWorkbenchSite site, final ISessionContext context, WidgetSupport support) {

        Display display = body.getDisplay();
        Font font = new Font(display, "Arial", 12, SWT.NONE); 

    	Composite composite = new Composite(body, SWT.NONE);
        composite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(composite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(composite);
    	
        Composite headerComposite = new Composite(composite, 0);
        headerComposite.setBackground(display.getSystemColor(SWT.COLOR_BLACK));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(2,2,2,2).applyTo(headerComposite);

        Composite headerComposite2 = new Composite(headerComposite, 0);
        headerComposite2.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite2);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(3,3,3,3).applyTo(headerComposite2);

        Label header = new Label(headerComposite2, support, 0);
        //header.setTextFactory(new VariableStringPropertyFactory(" Variable - %1", "#URI"));
        header.setText("Expression");
        header.setFont(font);
        header.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(SWT.CENTER, SWT.CENTER).applyTo(header.getWidget());
        
//    	Label label = new Label(composite, support, SWT.NONE);
//    	label.setText("Expression: ");
//        label.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().grab(false, false).applyTo(label.getWidget());
    	
        TrackedText name = new TrackedText(composite, support, SWT.BORDER | SWT.MULTI);
        name.setTextFactory(new VariableStringPropertyFactory("#Expression"));
        name.addModifyListener(new VariableStringPropertyTextModifier("Expression"));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(name.getWidget());
        
    }
   
}
