/*******************************************************************************
 * Copyright (c) 2007- VTT Technical Research Centre of Finland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.function.Consumer;

import org.simantics.db.Resource;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Antti Villberg
 */
public class SheetClass {

	public static final Key  KEY_SERVER_INTERFACE = new KeyOf(Adaptable.class, "SERVER_INTERFACE");

	public static final Key  KEY_SHEET = new KeyOf(Resource.class, "SHEET");
	public static final Key  KEY_RVI = new KeyOf(String.class, "RVI");
	public static final Key  KEY_SG_NODE             = new SceneGraphNodeKey(Node.class, "SG_NODE");

	public static class SheetSGNode implements SceneGraph, InternalSize, Outline {

		private static final long serialVersionUID = -5823585015844593347L;

		static final SheetSGNode INSTANCE = new SheetSGNode();

		@Override
		public void init(final IElement e, final G2DParentNode parent) {

			// Create node if it doesn't exist yet
			SheetNode node = (SheetNode)e.getHint(KEY_SG_NODE);
			if(node == null || node.getBounds() == null || node.getParent() != parent) {

				node = parent.addNode(ElementUtils.generateNodeId(e), SheetNode.class);

				e.setHint(KEY_SG_NODE, node);

				Adaptable serverInterface = e.getHint(KEY_SERVER_INTERFACE);
				node.init(serverInterface);

				Consumer<Node> callback = e.getHint(ElementHints.KEY_SG_CALLBACK);
				if(callback != null)
					callback.accept(node);

				System.out.println("SHEET PARENT NODE: " + parent);
				node.setBounds(new Rectangle2D.Double(0, 0, 400, 200));

			}

			update(e);

		}

		public void update(IElement e) {
		}

		@Override
		public void cleanup(IElement e) {
			SheetNode node = (SheetNode)e.removeHint(KEY_SG_NODE);
			if (node != null)
				node.remove();
		}

		@Override
		public Rectangle2D getBounds(IElement e, Rectangle2D size) {
			Rectangle2D shape = new Rectangle2D.Double(0, 0, 0, 0);

			SheetNode node = (SheetNode)e.getHint(KEY_SG_NODE);
			if(node != null && node.getBounds() != null) {
				shape = node.getBounds().getBounds2D();
			}

			if(size != null) size.setRect(shape);
			return shape;
		}

		@Override
		public Shape getElementShape(IElement e) {
			Shape shape = new Rectangle2D.Double(0, 0, 0, 0);

			SheetNode node = (SheetNode)e.getHint(KEY_SG_NODE);
			if(node != null && node.getBounds() != null) {
				shape = node.getBounds();
			}

			return shape;
		}

	}


	public static final ElementClass INSTANCE =
			ElementClass.compile(
					DefaultTransform.INSTANCE,
					BorderColorImpl.BLACK,
					SheetSGNode.INSTANCE,
					SimpleElementLayers.INSTANCE
					);

}
