package org.simantics.spreadsheet.solver;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@SuppressWarnings("rawtypes")
public class SpreadsheetTypeNode implements SheetNode {

	private static final long serialVersionUID = 8008959901150210428L;

	public final String uri;

	public SpreadsheetTypeNode(String uri) {
		this.uri = uri;
	}

	@Override
	public String getName() {
		return "typeURI";
	}

	@Override
	public Map getChildren() {
		return Collections.emptyMap();
	}

	@Override
	public Map getProperties() {
		return Collections.emptyMap();
	}

	@Override
	public int hashCode() {
		return Objects.hash(uri);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SpreadsheetTypeNode other = (SpreadsheetTypeNode) obj;
		return Objects.equals(uri, other.uri);
	}

}