package org.simantics.spreadsheet.solver;

import java.io.Serializable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;

public class SpreadsheetFormula implements Serializable {

    public static Binding BINDING = Bindings.getBindingUnchecked(SpreadsheetFormula.class);
    
    private static final long serialVersionUID = -3369406031425959191L;

    public AstValue value;
    public String expression;
    public Object result;

    public SpreadsheetFormula(AstValue value, String expression) {
        this.value = value;
        this.expression = expression;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((expression == null) ? 0 : expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SpreadsheetFormula other = (SpreadsheetFormula) obj;
        if (expression == null) {
            if (other.expression != null)
                return false;
        } else if (!expression.equals(other.expression))
            return false;
        return true;
    }

    @Override
    public String toString() {
        String s = result != null ? result.toString() : "";
        return getClass().getSimpleName() + " [" + expression +" => " + s + "]";
    }

}
