package org.simantics.spreadsheet.graph.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.ChildCreationData;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.Modification;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.PropertyCreationData;
import org.simantics.spreadsheet.common.cell.VariableCellEditor;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class TextCellVariable extends StandardGraphChildVariable {

	public TextCellVariable(Variable parent, Resource resource) throws DatabaseException {
		super(parent, null, resource);
	}
	
	@Override
	public String getLabel(ReadGraph graph) throws DatabaseException {
		return null;
	}
	
    @SuppressWarnings("unchecked")
    protected <T> T tryAdapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
    	if(VariableCellEditor.class == clazz) {
    		return (T)new VariableCellEditor() {
				
				@Override
				public void edit(WriteGraph graph, Variable cell, String text) throws DatabaseException {
					
					SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
					Resource configuration = cell.getPossibleRepresents(graph);
					graph.claimLiteral(configuration, sr.Cell_content, Variant.ofInstance(text), Bindings.VARIANT);
					
				}
				
				@Override
				public void copy(WriteGraph graph, Variable cell, String location) throws DatabaseException {
					
					SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
					Resource configuration = cell.getPossibleRepresents(graph);
					Variant content = graph.getPossibleRelatedValue(configuration, sr.Cell_content, Bindings.VARIANT);
					PropertyCreationData[] pData = new PropertyCreationData[] { PropertyCreationData.build(SpreadsheetResource.URIs.Cell_content, content) };
					ChildCreationData data = ChildCreationData.build(location, SpreadsheetResource.URIs.TextCell, pData);
					Variable sheet = cell.getParent(graph);
					VariableSpaceManipulator manipulator = sheet.adapt(graph, VariableSpaceManipulator.class);
					manipulator.apply(graph, Modification.addChild(data));
					
				}
				
			};
    	}
    	return null;
    }

    @Override
    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = tryAdapt(graph, clazz);
        return t != null ? t : super.adapt(graph, clazz);
    }

    @Override
    public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = tryAdapt(graph, clazz);
        return t != null ? t : super.adaptPossible(graph, clazz);
    }

}
