package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.swt.GraphExplorerDialog2;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.datastructures.Pair;

public class SaveSpreadsheetStateDialog extends GraphExplorerDialog2 {

    private static final String SELECT_CUSTOM = "Select custom..";
    
    private Combo parentSelector;
    private Pair<String, Resource>[] pairs;
    private String[] parents;

    private Text stateName;

    private String currentItem;
    private String currentStateName;
    
    private List<Resource> result;
    
    public SaveSpreadsheetStateDialog(IWorkbenchSite site, String title, Pair<String, Resource>[] pairs) {
        super(site, title);
        this.pairs = pairs;
        
        Resource book = pairs[0].second;
        Resource context = pairs[1].second;
        
        try {
            result = Simantics.getSession().syncRequest(new UniqueRead<List<Resource>>() {

                @Override
                public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                    Resource bookINdex = graph.syncRequest(new PossibleIndexRoot(book));
                    Resource contextIndex = graph.syncRequest(new PossibleIndexRoot(context)); 
                    
                    List<Resource> result = new ArrayList<>();
                    Set<Resource> indexRoots = Layer0Utils.listIndexRoots(graph);
                    for (Resource indexRoot : indexRoots) {
                        if (graph.syncRequest(new IsLinkedTo(indexRoot, bookINdex)) && graph.syncRequest(new IsLinkedTo(indexRoot, contextIndex))) {
                            result.add(indexRoot);
                        }
                    }
                    return result;
                }
            });
        } catch (DatabaseException e) {
            e.printStackTrace();
        }
        
        String[] newParents = new String[pairs.length + 1];
        for (int i = 0; i < pairs.length; i++) {
            newParents[i] = pairs[i].first;
        }
        newParents[pairs.length] = SELECT_CUSTOM;
        this.parents = newParents;
    }

    @Override
    public Set<String> getBrowseContexts() {
        return Collections.singleton("http://www.simantics.org/Project-1.2/ProjectBrowseContext");
    }
    
    @Override
    protected SessionContextInputSource getInputSource() {
        return super.getInputSource();
    }

    @Override
    protected void createControls(Composite body, ISessionContext context, WidgetSupport support) {
        
        Composite upperComposite = new Composite(body, SWT.NONE);
        GridLayout layout = new GridLayout(2, false);
        upperComposite.setLayout(layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(upperComposite);
        
        Composite explorerComposite = new Composite(body, SWT.NONE);
        explorerComposite.setLayout(new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(explorerComposite);
        
        Label parentLabel = new Label(upperComposite, SWT.NONE);
        parentLabel.setText("Select parent: ");
        
        parentSelector = new Combo(upperComposite, SWT.READ_ONLY);
        parentSelector.setItems(parents);
        parentSelector.select(0);
        
        GridDataFactory.fillDefaults().grab(true, false).applyTo(parentSelector);
        
        parentSelector.addSelectionListener(new SelectionAdapter() {
            
            @Override
            public void widgetSelected(SelectionEvent e) {
                hideOrShowGE();
            }
            
            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                widgetSelected(e);
            }
        });
        
        Label stateNameLabel = new Label(upperComposite, SWT.NONE);
        stateNameLabel.setText("Name of the state: ");
        GridDataFactory.fillDefaults().grab(false, false).applyTo(stateNameLabel);
        
        stateName = new Text(upperComposite, SWT.NONE);
        
        stateName.addModifyListener(new ModifyListener() {
            
            @Override
            public void modifyText(ModifyEvent e) {
                currentStateName = stateName.getText();
            }
        });
        
        GridDataFactory.fillDefaults().grab(true, false).applyTo(stateName);
        
        super.createControls(explorerComposite, context, support);
        
        hideOrShowGE();
    }

    private void hideOrShowGE() {
        int selection = parentSelector.getSelectionIndex();
        currentItem = parentSelector.getItem(selection);
        
        GraphExplorerComposite composite = getGraphExplorerComposite();
        GridData data = (GridData) composite.getLayoutData();
        
        if (currentItem.equals(SELECT_CUSTOM))
            data.exclude = false;
        else
            data.exclude = true;
        
         
        composite.setLayoutData(data);
        composite.setVisible(!data.exclude);
        composite.getParent().pack();
        composite.getParent().layout();
        composite.getParent().getParent().pack();
        composite.getParent().getParent().layout();
        composite.getParent().getParent().getParent().getParent().getParent();
        composite.getShell().pack();
        composite.getShell().layout();
//        explorerComposite.pack();
//        explorerComposite.getShell().layout(false);
    }
    
    
    
    @Override
    public Object[] getSelection() {
        if (currentItem.equals(SELECT_CUSTOM)) {
            Object[] selection = super.getSelection();
            NodeContext context = (NodeContext)selection[0];
            Object obj = context.getConstant(BuiltinKeys.INPUT);
            return new Object[] { Pair.make(obj, currentStateName) };
        } else {
            for (int i = 0; i < pairs.length; i++) {
                Pair<String, Resource> p = pairs[i];
                if (p.first.equals(currentItem)) {
                    return new Object[] {Pair.make(p.second, currentStateName) };
                }
            }
        }
        return null;
    }
    
}
