/*******************************************************************************
 * Copyright (c) 2007, 2014 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - optional fillStackTrace
 *******************************************************************************/
package org.simantics;

/**
 * @author Toni Kalajainen
 */
public class PlatformException extends Exception {

    private static final long serialVersionUID = -2967261259650645038L;

    private final boolean fillStackTrace;

    public PlatformException() {
        this(true);
    }

    public PlatformException(String message) {
        this(message, true);
    }

    public PlatformException(Throwable cause) {
        this(cause, true);
    }

    public PlatformException(String message, Throwable cause) {
        this(message, cause, true);
    }

    /**
     * @since Simantics 1.15
     */
    public PlatformException(boolean fillStackTrace) {
        this.fillStackTrace = fillStackTrace;
    }

    /**
     * @since Simantics 1.15
     */
    public PlatformException(String message, boolean fillStackTrace) {
        super(message);
        this.fillStackTrace = fillStackTrace;
    }

    /**
     * @since Simantics 1.15
     */
    public PlatformException(Throwable cause, boolean fillStackTrace) {
        super(cause);
        this.fillStackTrace = fillStackTrace;
    }

    /**
     * @since Simantics 1.15
     */
    public PlatformException(String message, Throwable cause, boolean fillStackTrace) {
        super(message, cause);
        this.fillStackTrace = fillStackTrace;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return fillStackTrace ? super.fillInStackTrace() : this;
    }

}