/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics;

import org.simantics.internal.Activator;

/**
 * @author Tuukka Lehtonen <tuukka.lehtonen@semantum.fi>
 */
public class AutosavePreferences {

    /**
     * The system property name that can be used to externally enable/disable
     * the current database connection virtual graph auto-save feature.
     * 
     * Set the value to "false" to globally disable virtual graph autosave.
     * Otherwise the preference {@link #P_VG_AUTOSAVE_ENABLED} will govern the
     * enabled-state of the feature.
     */
    public static final String  SYSTEM_PROPERTY_AUTOSAVE     = "db.vg.autosave";

    public static final String  P_NODE                       = Activator.PLUGIN_ID;

    /**
     * Preference for defining the enabled state of virtual graph autosave.
     */
    public static final String  P_VG_AUTOSAVE_ENABLED        = "virtualgraph.autosave.enabled"; //$NON-NLS-1$

    /**
     * Preference for defining the virtual graph autosave period time in
     * seconds.
     */
    public static final String  P_VG_AUTOSAVE_INTERVAL       = "virtualgraph.autosave.interval"; //$NON-NLS-1$

    public static final boolean DEFAULT_VG_AUTOSAVE_ENABLED  = true;
    public static final int     DEFAULT_VG_AUTOSAVE_INTERVAL = 90;

}
