/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.data;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.simantics.simulation.data.Datasource;
import org.simantics.utils.datastructures.ListenerList;

public abstract class AbstractDatasource
implements Datasource {
    protected ListenerList<Datasource.DatasourceListener> listeners = new ListenerList(Datasource.DatasourceListener.class);
    protected Lock readLock = this.writeLock = new ReentrantLock();
    protected Lock writeLock;

    @Override
    public void addListener(Datasource.DatasourceListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(Datasource.DatasourceListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void notifyStep(Datasource source) {
        Datasource.DatasourceListener[] datasourceListenerArray = (Datasource.DatasourceListener[])this.listeners.getListeners();
        int n = datasourceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Datasource.DatasourceListener l = datasourceListenerArray[n2];
            if (l.getExecutor() == null) {
                l.onStep(source);
            } else {
                l.getExecutor().execute(() -> l.onStep(source));
            }
            ++n2;
        }
    }

    protected void notifyStep() {
        this.notifyStep(this);
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }
}

