/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.io.IOException;
import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.ModelledVariablePropertyDescriptor;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.selectionview.SelectionViewResources;

public class DisplayValueVariableAdapter
extends SimpleContextualAdapter<Variable, ModelledVariablePropertyDescriptor> {
    final String key;

    public DisplayValueVariableAdapter() {
        this.key = "http://www.simantics.org/SelectionView-1.2/HasDisplayValue";
    }

    public DisplayValueVariableAdapter(String key) {
        this.key = key;
    }

    public static boolean isPrimitive(Datatype dt) {
        return Datatypes.STRING.equals((Object)dt);
    }

    private static String possibleExpression(ReadGraph graph, Variable variable) throws DatabaseException {
        String expression;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource object = variable.getPossibleRepresents(graph);
        if (object != null && graph.isInstanceOf(object, MOD.SCLValue) && (expression = (String)graph.getPossibleRelatedValue(object, L0.SCLValue_expression)) != null) {
            return "=" + expression;
        }
        return null;
    }

    public Variable adapt(ReadGraph graph, Resource source, ModelledVariablePropertyDescriptor context) throws DatabaseException {
        return new Impl(graph, context.getVariable(), context.getSubject(), (Datatype)Datatypes.STRING);
    }

    public static Object standardGetDisplayValue1(ReadGraph graph, Variable property_) throws DatabaseException {
        Datatype dt;
        Variable property = property_.getParent(graph);
        String expression = DisplayValueVariableAdapter.possibleExpression(graph, property);
        if (expression != null) {
            return expression;
        }
        Object value = null;
        Resource formatter = (Resource)property.getPossiblePropertyValue(graph, "HasFormatter");
        if (formatter != null) {
            Formatter fmt = (Formatter)graph.adaptContextual(formatter, (Object)property, Variable.class, Formatter.class);
            value = fmt.format(property.getValue(graph));
        }
        if (value == null) {
            SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
            Function1 formatterFunction = (Function1)property.getPossiblePropertyValue(graph, SEL.formatter);
            if (formatterFunction != null) {
                value = formatterFunction.apply(property.getValue(graph));
            }
        }
        if (value == null && (dt = property.getPossibleDatatype(graph)) != null && !DisplayValueVariableAdapter.isPrimitive(dt)) {
            Binding binding = Bindings.getBinding((Datatype)dt);
            try {
                value = DataValuePrinter.writeValueSingleLine((Binding)binding, (Object)property.getValue(graph));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (BindingException e) {
                e.printStackTrace();
            }
        }
        return value != null ? value.toString() : "null";
    }

    public static Object standardGetDisplayValue2(ReadGraph graph, Variable property, Binding binding) throws DatabaseException {
        try {
            return Bindings.adapt((Object)DisplayValueVariableAdapter.standardGetDisplayValue1(graph, property), (Binding)Bindings.STRING, (Binding)binding);
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void standardSetDisplayValue2(WriteGraph graph, Variable property_, Object _value) throws DatabaseException {
        try {
            Binding binding = Bindings.getBinding(_value.getClass());
            DisplayValueVariableAdapter.standardSetDisplayValue3(graph, property_, _value, binding);
        }
        catch (BindingConstructionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void standardSetDisplayValue3(WriteGraph graph, Variable property_, Object _value, Binding binding_) throws DatabaseException {
        try {
            Variable parent = property_.getParent((ReadGraph)graph);
            if (!(_value instanceof String)) {
                throw new DatabaseException("setValue for HasDisplayValue only accepts String (got " + _value.getClass().getSimpleName() + ")");
            }
            String text = (String)_value;
            if (text.startsWith("=")) {
                Layer0Utils.setExpression((WriteGraph)graph, (Variable)parent, (String)text, (Resource)ModelingResources.getInstance((ReadGraph)graph).SCLValue);
                return;
            }
            String parsedLabel = (String)_value;
            Object value = parsedLabel;
            Datatype type = parent.getPossibleDatatype((ReadGraph)graph);
            if (type != null) {
                Binding binding = Bindings.getBinding((Datatype)type);
                if (binding instanceof StringBinding) {
                    value = binding instanceof MutableStringBinding ? new MutableString(parsedLabel) : parsedLabel;
                } else {
                    if (binding instanceof NumberBinding) {
                        parsedLabel = parsedLabel.replace(",", ".");
                    }
                    value = binding.parseValue(parsedLabel, new DataValueRepository());
                }
                parent.setValue(graph, value, binding);
            } else {
                parent.setValue(graph, value);
            }
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Set value " + ObjectUtils.toString((Object)value)));
        }
        catch (DataTypeSyntaxError e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static Datatype standardGetDisplayValueDatatype(ReadGraph graph, Variable property_) throws DatabaseException {
        return Datatypes.STRING;
    }

    class Impl
    extends StandardGraphPropertyVariable {
        private Datatype datatype;

        public Impl(ReadGraph graph, Variable parent, Resource parentResource, Datatype datatype) throws DatabaseException {
            super(graph, parent, null, parentResource, graph.getResource(DisplayValueVariableAdapter.this.key));
            this.datatype = datatype;
        }

        public <T> T getValue(ReadGraph graph) throws DatabaseException {
            return (T)DisplayValueVariableAdapter.standardGetDisplayValue1(graph, (Variable)this);
        }

        public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
            return (T)DisplayValueVariableAdapter.standardGetDisplayValue2(graph, (Variable)this, binding);
        }

        public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
            return this.datatype;
        }

        public void setValue(WriteGraph graph, Object value) throws DatabaseException {
            DisplayValueVariableAdapter.standardSetDisplayValue2(graph, (Variable)this, value);
        }

        public void setValue(WriteGraph graph, Object _value, Binding _binding) throws DatabaseException {
            DisplayValueVariableAdapter.standardSetDisplayValue3(graph, (Variable)this, _value, _binding);
        }
    }
}

