package org.simantics.scl.ui.browser;

import java.util.Comparator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.module.repository.ModuleRepositories;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;

public class SCLDefinitionSelectionDialog extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "SCLDefinitionSelectionDialogSettings"; //$NON-NLS-1$

    public SCLDefinitionSelectionDialog(Shell shell) {
        super(shell, false);
        setTitle(Messages.SCLDefinitionSelectionDialog_ChooseSCLDefinition);
        setSelectionHistory(new DefinitionSelectionHistory());
        setListLabelProvider(new LabelProvider() {
            @Override
            public String getText(Object element) {
                if(element instanceof String)
                    return (String)element;
                SCLValue value = (SCLValue)element;
                if(element == null)
                    return ""; //$NON-NLS-1$
                Name name = value.getName();
                return name.name + " (" + name.module + ") :: " + value.getType(); //$NON-NLS-1$ //$NON-NLS-2$
            }
        });
    }

    private class DefinitionSelectionHistory extends SelectionHistory {
        protected Object restoreItemFromMemento(IMemento element) {
            //return element.getString("resource"); //$NON-NLS-1$
            return null;
        }
        protected void storeItemToMemento(Object item, IMemento element) {
            //element.putString("resource", item.toString()); //$NON-NLS-1$
        }
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
         IDialogSettings settings = Activator.getInstance().getDialogSettings().getSection(DIALOG_SETTINGS);
         if (settings == null)
             settings = Activator.getInstance().getDialogSettings().addNewSection(DIALOG_SETTINGS);
         return settings;
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    @Override
    protected ItemsFilter createFilter() {
        return new ItemsFilter() {
            {
                String patternText = getPattern();
                patternMatcher = new SearchPattern();
                if(patternText != null && patternText.length() > 0)
                    patternMatcher.setPattern(patternText);
                else 
                    patternMatcher.setPattern("*"); //$NON-NLS-1$
            }
            
            @Override
            public boolean matchItem(Object item) {
                String text = item.toString();
                if(getPattern().contains("/")) //$NON-NLS-1$
                    return matches(text);
                else {
                    int p = text.lastIndexOf('/');
                    if(p >= 0)
                        text = text.substring(p+1);
                    return matches(text);
                }
            }

            @Override
            public boolean isConsistentItem(Object item) {
                return true;
            }
            
        };
    }

    @SuppressWarnings("rawtypes")
    @Override
    protected Comparator getItemsComparator() {
        return new Comparator() {
            public int compare(Object arg0, Object arg1) {
                SCLValue a = (SCLValue)arg0;
                SCLValue b = (SCLValue)arg1;
                int cmp = a.getName().name.compareTo(b.getName().name);
                if(cmp != 0)
                    return cmp;
                return a.getName().module.compareTo(b.getName().module);
            }
        };
    }

    @Override
    protected void fillContentProvider(AbstractContentProvider contentProvider,
            ItemsFilter itemsFilter, IProgressMonitor progressMonitor)
                    throws CoreException {
        progressMonitor.beginTask("Searching", 1); //$NON-NLS-1$
        for(SCLValue value : ModuleRepositories.allValues(SCLOsgi.MODULE_REPOSITORY)) {
            if(isTupleValue(value.getName()))
                continue;
            contentProvider.add(value, itemsFilter);
        }
        progressMonitor.worked(1);
        progressMonitor.done();
    }

    private boolean isTupleValue(Name name) {
        return name.module.equals(Types.BUILTIN) && name.name.startsWith("(") && //$NON-NLS-1$
                (name.name.equals("()") || name.name.charAt(1) == ','); //$NON-NLS-1$
    }

    @Override
    public String getElementName(Object item) {
        return item.toString();
    }

}
