/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.rest;

import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.internal.RuntimeDelegateImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.scl.rest.SCLRESTServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String START_SERVER = "org.simantics.scl.rest.startServer";
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        String onStartup = System.getProperty(START_SERVER);
        if (onStartup != null && !onStartup.isEmpty()) {
            try {
                String[] tokenAndPort = onStartup.split("::");
                SCLRESTServer.start(tokenAndPort[0], Integer.parseInt(tokenAndPort[1]));
            }
            catch (Exception e) {
                LOGGER.error("Could not start server with value {}. It should be in the form of <secret-token>::<port-number>", (Object)onStartup, (Object)e);
            }
        }
        context = bundleContext;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        SCLRESTServer.stop();
        context = null;
    }
}

