package org.simantics.scl.rest;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Future;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;

import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public class HttpClientUtils {
    
    public static Client buildClient(ClientBuilder clientBuilder) {
        final ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(MultiPartFeature.class);
        return clientBuilder.withConfig((Configuration) clientConfig).build();
    }
    
    public static String statusMessageOf(Response response) {
        return response.getStatusInfo().getReasonPhrase();
    }
    
    public static Future<Response> asyncInvoke(Invocation invocation, Function1<Response, Tuple0> responseCallback, Function1<Throwable, Tuple0> failureCallback) {
        SCLContext context = SCLContext.createDerivedContext();
        
        return invocation.submit(new InvocationCallback<Response>() {

            @Override
            public void completed(Response response) {
                SCLContext.push(context);
                try {
                    responseCallback.apply(response);
                } finally {
                    SCLContext.pop();
                }
            }
            
            @Override
            public void failed(Throwable throwable) {
                SCLContext.push(context);
                try {
                    failureCallback.apply(throwable);
                } finally {
                    SCLContext.pop();
                }
                
            }
        });
    }

    public static ClientBuilder clientBuilder() {
        return new JerseyClientBuilder();
    }

    public static ClientBuilder trustAllClientBuilder() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[] {new X509TrustManager() {
            public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return null;
            }
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }
        };

        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new java.security.SecureRandom());

        return (new JerseyClientBuilder()).sslContext(sc).hostnameVerifier(new HostnameVerifier() {
            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }
    
    public static void onWriteProgress(WebTarget target, Function1<Long, Tuple0> callback) {
        target.register(new WriteProgressInterceptor(callback));
    }
    
    public static void onReadProgress(WebTarget target, Function1<Long, Tuple0> callback) {
        target.register(new ReadProgressInterceptor(callback));
    }
    
    public static Long possibleContentLengthOf(Response response) {
        String lengthStr = response.getHeaderString("Content-Length");
        if (lengthStr != null) {
            try {
                return Long.parseLong(lengthStr);
            } catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
    }

}
