package org.simantics.scl.reflection.internal.registry;

import java.lang.reflect.Method;

import org.osgi.framework.Bundle;

public class ExternalMethod {
    public final Bundle bundle;
    public final String className;
    public final String methodName;
    public final String alternativeName;
    
    public ExternalMethod(Bundle bundle, String className, String methodName,
            String alternativeName) {
        this.bundle = bundle;
        this.className = className;
        this.methodName = methodName;
        this.alternativeName = alternativeName;
    }    
    
    public Class<?> loadClass() {
        try {
            return bundle.loadClass(className);
        } catch (ClassNotFoundException e) {
            return null;
        }   
    }
    
    public Method getMethod(Class<?> clazz) {
        for(Method method : clazz.getMethods())
            if(method.getName().equals(methodName))
                return method;
        return null;
    }
}
