/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi;

import gnu.trove.procedure.TObjectProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.java.SafeExternalConstant;
import org.simantics.scl.compiler.errors.DoesNotExist;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.compiler.testing.repository.TestRepository;
import org.simantics.scl.osgi.internal.Activator;
import org.simantics.scl.osgi.internal.ServiceBasedModuleSourceRepository;
import org.simantics.scl.osgi.internal.ServiceBasedTestRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLOsgi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLOsgi.class);
    public static ModuleSourceRepository SOURCE_REPOSITORY = new ServiceBasedModuleSourceRepository(Activator.getContext());
    public static ModuleRepository MODULE_REPOSITORY = new SCLOsgiModuleRepository(SOURCE_REPOSITORY);
    public static TestRepository TEST_REPOSITORY = new ServiceBasedTestRepository(Activator.getContext());

    private SCLOsgi() {
    }

    public static String compileAllModules() {
        final ArrayList modulesWithErrors = new ArrayList();
        SOURCE_REPOSITORY.forAllModules((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String moduleName) {
                Failable module = MODULE_REPOSITORY.getModule(moduleName);
                if (module.didSucceed()) {
                    LOGGER.trace("{} - {}", (Object)moduleName, (Object)"succeeded");
                } else if (module == DoesNotExist.INSTANCE) {
                    LOGGER.trace("{} - {}", (Object)moduleName, (Object)"does not exist");
                } else {
                    LOGGER.trace("{} - {}", (Object)moduleName, (Object)"error");
                    modulesWithErrors.add(moduleName);
                }
                return true;
            }
        });
        if (!modulesWithErrors.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("Some SCL modules failed to compile:");
            for (String module : modulesWithErrors) {
                b.append(' ').append(module);
            }
            return b.toString();
        }
        return null;
    }

    public static class SCLOsgiModuleRepository
    extends ModuleRepository
    implements SafeExternalConstant,
    Externalizable {
        public SCLOsgiModuleRepository() {
            super(null);
        }

        public SCLOsgiModuleRepository(ModuleSourceRepository sourceRepository) {
            super(sourceRepository);
        }

        protected Object readResolve() {
            return MODULE_REPOSITORY;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

