/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.html.HtmlGenerationContext;
import org.simantics.scl.compiler.markdown.internal.HtmlEscape;
import org.simantics.scl.compiler.markdown.nodes.Node;

public class LinkNode
extends Node {
    public String label;
    public String url;
    public String title;

    public LinkNode(String label, String url, String title) {
        this.label = label;
        this.url = url;
        this.title = title;
    }

    @Override
    public void toHtml(HtmlGenerationContext context, StringBuilder b) {
        b.append("<a href=\"").append((CharSequence)HtmlEscape.escapeURL(this.url));
        if (this.title.isEmpty()) {
            b.append("\">");
        } else {
            b.append("\" title=\"");
            b.append(HtmlEscape.escape(this.title));
            b.append("\">");
        }
        super.toHtml(context, b);
        b.append("</a>");
    }
}

