/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.types;

import java.util.HashMap;
import java.util.Map;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class BTypes {
    public static final TCon PROC = Types.con("Builtin", "Proc");

    public static void bind(Type declared, Type bound, Map<TMetaVar, Type> bindings) {
        if (bound instanceof TCon) {
            return;
        }
        if (declared instanceof TApply && bound instanceof TApply) {
            BTypes.bind(((TApply)declared).parameter, ((TApply)bound).parameter, bindings);
        }
        if (declared instanceof TMetaVar && !bindings.containsKey(declared)) {
            bindings.put((TMetaVar)declared, bound);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type[] matchFunction(Type type_, Val[] parameters, int arity) throws MatchException {
        HashMap<TMetaVar, Type> bindings = new HashMap<TMetaVar, Type>();
        Type type = Types.canonical(type_);
        Type[] result = new Type[arity + 1];
        int i = 0;
        while (i < arity) {
            if (type instanceof TMetaVar) {
                type = ((Type)bindings.get(type)).canonical();
            }
            if (type instanceof TFun) {
                TFun fun = (TFun)type;
                BTypes.bind(fun.domain, parameters[i].getType().canonical(), bindings);
                result[i] = fun.domain;
                type = fun.range;
            } else {
                if (!(type instanceof TApply)) throw new MatchException("Type=" + String.valueOf(type) + " " + type.getClass().getName() + " i=" + i);
                TApply apply1 = (TApply)type;
                Type function1 = Types.canonical(apply1.function);
                if (!(function1 instanceof TApply)) throw new MatchException();
                TApply apply2 = (TApply)function1;
                Type function2 = Types.canonical(apply2.function);
                if (function2 != Types.ARROW) throw new MatchException();
                result[i] = apply2.parameter;
                type = Types.canonical(apply1.parameter);
            }
            ++i;
        }
        result[arity] = type;
        return result;
    }
}

