/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class GetVector
extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    private final TCon constructor;

    public GetVector(Type effect, TCon constructor) {
        super(new TVar[]{A}, effect, A, Types.apply((Type)constructor, (Type)A), Types.INTEGER);
        this.constructor = constructor;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Val vector = parameters[0];
        Val index = parameters[1];
        vector.push(mb);
        index.push(mb);
        try {
            Type elementType = Types.canonical(Types.matchApply(this.constructor, vector.getType()));
            if (elementType instanceof TVar) {
                mb.invokeStatic("java/lang/reflect/Array", "get", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.INT});
                return A;
            }
            TypeDesc desc = mb.getJavaTypeTranslator().toTypeDesc(elementType);
            mb.loadFromArray(desc);
            return elementType;
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }
}

