package org.simantics.scl.compiler.source.repository;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.runtime.SCLContext;

import gnu.trove.procedure.TObjectProcedure;

public class SourceRepositories {
    public static final ModuleSourceRepository BUILTIN_SOURCE_REPOSITORY = new BuiltinModuleSourceRepository();
    
    public static final ModuleSourceRepository PRELUDE_SOURCE_REPOSITORY = createPreludeSourceEnvironment();

    private static ModuleSourceRepository createPreludeSourceEnvironment() {
        try {
            File directory = getPreludeDirectory();
            if(directory != null) {
                return new FileModuleSourceRepository(directory, SourceRepositories.class.getClassLoader()) {
                    protected ImportDeclaration[] getBuiltinImports() {
                        return ImportDeclaration.ONLY_BUILTINS;
                    }
                };
            }
            
            // Hope that ClassSourceEnvironment works
            return new ClassModuleSourceRepository(SCLContext.class, SourceRepositories.class.getClassLoader(), "/scl") {
                protected ImportDeclaration[] getBuiltinImports() {
                    return ImportDeclaration.ONLY_BUILTINS;
                }
            };
        } catch(IOException e) {
            e.printStackTrace();
            return null;
        }
    }
    
    private static File getPreludeDirectory() throws IOException {
        URL url = SCLContext.class.getResource(".");
        if(url == null)
            return null;
        File file = ModuleBrowsingUtil.toFile(url);
        if(file == null)
            return null;
        File preludeDir = new File(file, "../../../../scl");
        if(preludeDir.exists())
            return preludeDir.getCanonicalFile();
        preludeDir = new File(file, "../../../../../scl");
        if(preludeDir.exists())
            return preludeDir.getCanonicalFile();
        return null;
    }
    
    public static List<String> getModuleNames(ModuleSourceRepository repository) {
        final ArrayList<String> result = new ArrayList<String>(); 
        repository.forAllModules(new TObjectProcedure<String>() {
            @Override
            public boolean execute(String moduleName) {
                result.add(moduleName);
                return true;
            }
        });
        return result;
    }
}
