package org.simantics.scl.compiler.runtime;

import java.util.Map;

import org.simantics.scl.compiler.constants.Constant;

import gnu.trove.map.hash.THashMap;

public interface MutableClassLoader {

    public static final String SCL_PACKAGE_PREFIX = "scl.";
    public static final int SCL_PACKAGE_PREFIX_LENGTH = SCL_PACKAGE_PREFIX.length();

    void addClasses(Map<String, byte[]> classes);
    Class<?> loadClass(String className) throws ClassNotFoundException;
    String getFreshPackageName();
    THashMap<Constant, Object> getConstantCache();
    ClassLoader getClassLoader();
    byte[] getBytes(String className);

}
