package org.simantics.scl.compiler.internal.parsing.declarations;

import org.simantics.scl.compiler.elaboration.expressions.Expression;

public class DValueAst extends DeclarationAst {
    public final Expression lhs;
    public Expression value;
    public DDocumentationAst documentation;
    
    public DValueAst(Expression lhs, Expression value) {
        this.lhs = lhs;
        this.value = value;
    }
    
    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append(lhs);
        b.append(" = ");
        b.append(value);
    }

    public void toString(StringBuilder b) {
        toString(0, b);
    }

    public void setLocationDeep(long der) {
        lhs.setLocationDeep(der);
        value.setLocationDeep(der);
    }
}
