package org.simantics.scl.compiler.internal.interpreted;

import java.util.Objects;

public class IVariable implements IExpression {
    private final int variableId;

    public IVariable(int variableId) {
        this.variableId = variableId;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        return variableBindings[variableId];
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(variableId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IVariable other = (IVariable) obj;
        return variableId == other.variableId;
    }

    @Override
    public String toString() {
        return "v" + variableId;
    }
}
