package org.simantics.scl.compiler.internal.interpreted;

import java.util.Objects;

import org.simantics.scl.runtime.function.Function;


public class IConstant implements IExpression {
    private final Object value;

    public IConstant(Object value) {
        this.value = value;
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(value);
        }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IConstant other = (IConstant) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public Object execute(Object[] variableBindings) {
        return value;
    }
    
    @Override
    public String toString() {
        if(value == null)
            return "null";
        else if(value instanceof Number || value instanceof Function)
        	return value.toString();
        else if(value instanceof String)
        	return "\"" + value.toString() + "\"";
        else if(value instanceof Class)
        	return ((Class<?>)value).getSimpleName();
        else
            return "(" + value.toString() + "::" + value.getClass().getSimpleName() + ")";
    }

}
