package org.simantics.scl.compiler.internal.codegen.types;

import java.util.HashMap;
import java.util.Map;

import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

/**
 * Type utilites for SCL compiler backend
 */
public class BTypes {
    
    public static final TCon PROC = Types.con(Types.BUILTIN, "Proc");

    public static void bind(Type declared, Type bound, Map<TMetaVar,Type> bindings) {

        if(bound instanceof TCon)
            return;

        if(declared instanceof TApply && bound instanceof TApply) {
            bind(((TApply)declared).parameter, ((TApply)bound).parameter, bindings); 
        }

        if(declared instanceof TMetaVar) {
            if(!bindings.containsKey(declared))
                bindings.put((TMetaVar)declared, bound);
        }
    }

    public static Type[] matchFunction(Type type_, Val[] parameters, int arity) throws MatchException {
        Map<TMetaVar,Type> bindings = new HashMap<>();
        Type type = Types.canonical(type_);
        /*while(type instanceof TForAll)
            type = ((TForAll)type).type;*/
        Type[] result = new Type[arity+1];
        for(int i=0;i<arity;++i) {
            if(type instanceof TMetaVar) {
                 type = bindings.get(type).canonical();
            }
            if(type instanceof TFun) {
                TFun fun = (TFun)type;
                bind(fun.domain, parameters[i].getType().canonical(), bindings);
                result[i] = fun.domain;
                type = fun.range;
            }
            else if(type instanceof TApply) {
                TApply apply1 = (TApply)type;
                Type function1 = Types.canonical(apply1.function);
                if(function1 instanceof TApply) {
                    TApply apply2 = (TApply)function1;
                    Type function2 = Types.canonical(apply2.function);
                    if(function2 == Types.ARROW) {
                        result[i] = apply2.parameter;
                        type = Types.canonical(apply1.parameter);
                    }
                    else
                        throw new MatchException();
                }
                else
                    throw new MatchException();
            }
            else
                throw new MatchException("Type="+type+" "+type.getClass().getName()+" i=" + i);
        }
        result[arity] = type;
        return result;
    }

}
