package org.simantics.scl.compiler.elaboration.query;

import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;

public abstract class QAbstractModifier extends Query {
    public Query query;
    
    public QAbstractModifier(Query query) {
        this.query = query;
    }
    
    @Override
    public Query resolve(TranslationContext context) {
        query = query.resolve(context);
        return this;
    }

    @Override
    public void checkType(TypingContext context) {
        query.checkType(context);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            query.setLocationDeep(loc);
        }
    }
}
