package org.simantics.scl.compiler.elaboration.java;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class JavaExternalConstantReader implements ExternalConstantReader {

    static public final String EXTERN = "extern";

	@Override
	public void writeExternal(ObjectOutput out, Object value) throws IOException {
		if(value instanceof Externalizable) {
			out.writeUTF(EXTERN);
			out.writeObject(value);
			return;
		}
		throw new ExternalConstantException("Unhandled object " + value.getClass().toString());
	}
	
	public Object readExternal(ObjectInput in, String key) throws IOException, ClassNotFoundException {
		if(EXTERN.equals(key)) {
			try {
				return in.readObject();
			} catch (ClassNotFoundException e) {
				throw new ExternalConstantException("Failed to load class " + e.getMessage());
			}
		}
		throw new ExternalConstantException("Unhandled object " + key);
	}

	@Override
	final public Object readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
		return readExternal(in, in.readUTF());
	}

}
