package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ECHRRulesetConstructor extends Expression {
    transient public CHRRuleset ruleset;
    
    public ECHRRulesetConstructor(CHRRuleset ruleset) {
        this.ruleset = ruleset;
    }

    @Override
    protected void updateType() throws MatchException {
        throw new InternalCompilerError("Type of ECHRRulesetConstructor should be already given.");
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        return ruleset.generateCode(w);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushFrame();
        context.pushCHRConstraintFrame();
        ruleset.resolve(context);
        context.popCHRConstraintFrame(ruleset);
        context.popFrame();
        return this;
    }
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            this.location = loc;
            ruleset.setLocationDeep(loc);
        }
    }
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        ruleset.checkType(context);
        return this;
    }
    
    @Override
    public Expression simplify(SimplificationContext context) {
        ruleset.simplifyAndCompileIfNeeded(context);
        return this;
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
    
    @Override
    public IExpression toIExpression(ExpressionInterpretationContext context) {
        throw new UnsupportedOperationException();
    }

}
