/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.color;

import java.awt.Color;
import org.simantics.scenegraph.g2d.color.ColorFilter;

public class DefaultHoverColorFilter
implements ColorFilter {
    @Override
    public Color filter(Color c) {
        float[] hsl = DefaultHoverColorFilter.rgbToHSL(c);
        Color c2 = DefaultHoverColorFilter.hslToRGB(hsl[0], hsl[1], Math.max((double)0.4f, Math.min(1.0, (double)0.3f + (double)0.7f * Math.pow(hsl[2], 1.3f))));
        return c2;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    private static Color hslToRGB(double h, double s, double l) {
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double h2 = h / 60.0;
        double x = c * (1.0 - Math.abs(h2 % 2.0 - 1.0));
        double r1 = 0.0;
        double g1 = 0.0;
        double b1 = 0.0;
        if (0.0 <= h2 && h2 < 1.0) {
            r1 = c;
            g1 = x;
            b1 = 0.0;
        } else if (1.0 <= h2 && h2 < 2.0) {
            r1 = x;
            g1 = c;
            b1 = 0.0;
        } else if (2.0 <= h2 && h2 < 3.0) {
            r1 = 0.0;
            g1 = c;
            b1 = x;
        } else if (3.0 <= h2 && h2 < 4.0) {
            r1 = 0.0;
            g1 = x;
            b1 = c;
        } else if (4.0 <= h2 && h2 < 5.0) {
            r1 = x;
            g1 = 0.0;
            b1 = c;
        } else if (5.0 <= h2 && h2 <= 6.0) {
            r1 = c;
            g1 = 0.0;
            b1 = x;
        }
        double m = l - 0.5 * c;
        int R = (int)Math.round((r1 + m) * 255.0);
        int G = (int)Math.round((g1 + m) * 255.0);
        int B = (int)Math.round((b1 + m) * 255.0);
        return new Color(R, G, B);
    }

    private static float[] rgbToHSL(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float l = (max + min) / 2.0f;
        if (max == min) {
            return new float[]{0.0f, 0.0f, l};
        }
        float d = max - min;
        float s = d / (l <= 0.5f ? max + min : 2.0f - max - min);
        float h = 0.0f;
        if (max == r) {
            h = (60.0f * (g - b) / d + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / d + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / d + 240.0f;
        }
        return new float[]{h, s, l};
    }
}

