/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.Trend2DNode;
import org.simantics.scenegraph.swing.ComponentNode;

@ExportableWidget.RasterOutputWidget
public class MultiVariableTrendNode
extends ComponentNode<JPanel> {
    private static final long serialVersionUID = 8508750881358776559L;
    protected transient JFreeChart chart = null;
    protected transient List<List<Trend2DNode.TrendPoint>> points = new ArrayList<List<Trend2DNode.TrendPoint>>();
    protected transient XYSeriesCollection dataset = null;

    @Override
    public void init() {
        XYSeries serie = new XYSeries((Comparable)((Object)"Trend"));
        this.dataset = new XYSeriesCollection(serie);
        this.scale = false;
        this.chart = ChartFactory.createXYLineChart((String)"Trend", (String)"Value", (String)"Time", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = this.chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        this.component = new ChartPanel(this.chart, false);
        ((ChartPanel)this.component).setRefreshBuffer(false);
        ((JPanel)this.component).setIgnoreRepaint(true);
        ((JPanel)this.component).setDoubleBuffered(false);
        if (this.bounds != null) {
            ((JPanel)this.component).setBounds(0, 0, 0, 0);
        }
        int i = 0;
        while (i < this.points.size()) {
            if (this.dataset.getSeriesCount() < i) {
                XYSeries s = new XYSeries((Comparable)((Object)("Serie " + (i + 1))));
                this.dataset.addSeries(s);
                this.dataset.addSeries(s);
            }
            for (Trend2DNode.TrendPoint p : this.points.get(i)) {
                try {
                    this.dataset.getSeries(i).add(p.getX(), p.getY());
                }
                catch (SeriesException seriesException) {}
            }
            ++i;
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D g2d) {
        if (this.component != null) {
            AffineTransform ot = g2d.getTransform();
            g2d.transform(this.transform);
            double scaleX = g2d.getTransform().getScaleX();
            double scaleY = g2d.getTransform().getScaleY();
            AffineTransform at = new AffineTransform();
            at.setToTranslation(this.bounds.getMinX(), this.bounds.getMinY());
            at.scale(1.0 / scaleX, 1.0 / scaleY);
            g2d.transform(at);
            int width = (int)(this.bounds.getWidth() * scaleX);
            int height = (int)(this.bounds.getHeight() * scaleY);
            JPanel jPanel = (JPanel)this.component;
            synchronized (jPanel) {
                ((JPanel)this.component).setLocation((int)g2d.getTransform().getTranslateX(), (int)g2d.getTransform().getTranslateY());
                if (((JPanel)this.component).getSize().getWidth() != (double)width || ((JPanel)this.component).getSize().getHeight() != (double)height) {
                    ((JPanel)this.component).setSize(width, height);
                }
                ((JPanel)this.component).paint(g2d);
            }
            g2d.setTransform(ot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @INode.PropertySetter(value="Title")
    @INode.ClientSide
    public void setTitle(String title) {
        if (this.component != null) {
            JPanel jPanel = (JPanel)this.component;
            synchronized (jPanel) {
                ((ChartPanel)this.component).getChart().setTitle(title);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @INode.PropertySetter(value="X-Axis Label")
    @INode.ClientSide
    public void setXTitle(String xTitle) {
        if (this.component != null) {
            JPanel jPanel = (JPanel)this.component;
            synchronized (jPanel) {
                ((ChartPanel)this.component).getChart().getXYPlot().getDomainAxis().setLabel(xTitle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @INode.PropertySetter(value="Y-Axis Label")
    @INode.ClientSide
    public void setYTitle(String yTitle) {
        if (this.component != null) {
            JPanel jPanel = (JPanel)this.component;
            synchronized (jPanel) {
                ((ChartPanel)this.component).getChart().getXYPlot().getRangeAxis().setLabel(yTitle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @INode.ClientSide
    public void setPoints(List<Trend2DNode.TrendPoint> points, Integer serie) {
        while (this.dataset.getSeriesCount() <= serie) {
            this.points.add(new ArrayList());
            this.dataset.addSeries(new XYSeries((Comparable)((Object)("Trend " + (this.dataset.getSeriesCount() + 1)))));
        }
        this.points.add(serie, points);
        JPanel jPanel = (JPanel)this.component;
        synchronized (jPanel) {
            this.dataset.getSeries(serie.intValue()).clear();
            for (Trend2DNode.TrendPoint p : points) {
                try {
                    this.dataset.getSeries(serie.intValue()).add(p.getX(), p.getY());
                }
                catch (SeriesException seriesException) {}
            }
        }
    }

    @INode.ClientSide
    protected void appendPoints(List<Trend2DNode.TrendPoint> points, Integer serie) {
        while (this.dataset.getSeriesCount() <= serie) {
            this.points.add(new ArrayList());
            this.dataset.addSeries(new XYSeries((Comparable)((Object)("Trend " + (this.dataset.getSeriesCount() + 1)))));
        }
        if (this.location.equals((Object)INode.Location.REMOTE)) {
            this.points.get(serie).addAll(points);
        }
        for (Trend2DNode.TrendPoint p : points) {
            try {
                this.dataset.getSeries((Comparable)serie).add(p.getX(), p.getY());
            }
            catch (SeriesException seriesException) {}
        }
    }
}

