/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.scenegraph.utils.DummyComponent;

public class ComboBoxNode
extends ComponentNode<JComboBox>
implements ActionListener,
FocusListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 7073028693751719102L;
    protected boolean editable = true;
    protected String value = "";
    protected String tooltip = "";
    protected double borderWidth = 0.0;
    protected transient ActionListener actionListener = null;
    protected Font font = null;
    protected Color color = null;
    protected List<String> items = null;

    public String toString() {
        return super.toString() + "[editable=" + this.editable + ", value=" + this.value + "]";
    }

    @Override
    public void init() {
        this.component = new JComboBox();
        ((JComboBox)this.component).setLightWeightPopupEnabled(true);
        ((JComboBox)this.component).setEditable(this.editable);
        ((JComboBox)this.component).setEnabled(this.editable);
        ((JComboBox)this.component).addActionListener(this);
        ((JComboBox)this.component).addFocusListener(this);
        ((JComboBox)this.component).addKeyListener(this);
        ((JComboBox)this.component).addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                Accessible comp = box.getUI().getAccessibleChild(box, 0);
                if (!(comp instanceof JPopupMenu)) {
                    return;
                }
                JPopupMenu popup = (JPopupMenu)comp;
                Point2D p = ComboBoxNode.this.localToControl(new Point2D.Double());
                Point loc = new Point((int)p.getX(), (int)p.getY() + ((JComboBox)ComboBoxNode.this.component).getHeight());
                SwingUtilities.convertPointToScreen(loc, box.getParent());
                popup.setLocation((int)loc.getX(), (int)loc.getY());
            }
        });
        super.init();
    }

    @INode.SyncField(value={"items"})
    public void setItems(List<String> items) {
        this.items = items;
        ((JComboBox)this.component).removeAllItems();
        for (String str : items) {
            ((JComboBox)this.component).addItem(str);
        }
    }

    @INode.SyncField(value={"editable"})
    public void setEditable(boolean value) {
        this.editable = value;
        if (this.component != null) {
            ((JComboBox)this.component).setEditable(value);
            ((JComboBox)this.component).setEnabled(value);
        }
    }

    @INode.PropertySetter(value="Stroke Width")
    @INode.SyncField(value={"borderWidth"})
    public void setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth.floatValue();
    }

    @INode.SyncField(value={"value"})
    public void setText(String value) {
        this.value = value;
        if (this.component != null) {
            ((JComboBox)this.component).setSelectedItem(value);
            ((JComboBox)this.component).repaint();
        }
    }

    @INode.SyncField(value={"tooltip"})
    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        if (this.component != null) {
            ((JComboBox)this.component).setToolTipText(tooltip);
        }
    }

    @INode.PropertySetter(value="Font")
    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
        if (this.component != null) {
            this.setComponentFont(font);
        }
    }

    @INode.PropertySetter(value="Color")
    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
        if (this.component != null) {
            ((JComboBox)this.component).setForeground(color);
        }
    }

    public String getText() {
        return this.value;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName()) && this.component != null) {
            ((JComboBox)this.component).setSelectedItem(evt.getNewValue());
            ((JComboBox)this.component).repaint();
        } else if ("editable".equals(evt.getPropertyName()) && this.component != null) {
            ((JComboBox)this.component).setEditable((Boolean)evt.getNewValue());
            ((JComboBox)this.component).setEnabled((Boolean)evt.getNewValue());
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loseFocus();
    }

    void loseFocus() {
        if (this.component != null && ((JComboBox)this.component).isFocusOwner() && this.container.getParent() != null) {
            this.container.getParent().requestFocusInWindow();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.component != null) {
            ActionEvent e = new ActionEvent(this.component, 1001, (String)((JComboBox)this.component).getSelectedItem());
            this.performAction(e);
        }
    }

    @INode.ServerSide
    public void performAction(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getModifiers() == 0 && e.getKeyCode() == 27) {
            this.loseFocus();
        }
    }

    public void input(String input) {
        ActionEvent e = new ActionEvent(new DummyComponent(), 1001, input);
        this.performAction(e);
    }
}

